# get Hadamard matrices from: http://www.neilsloane.com/hadamard/index.html
import numpy as np


template = """
def get_had{N}():
    return torch.FloatTensor([
    {Matrix}
    ])
"""


had_44_will = """
+-++----++-++-++--++-+++-+-++-+-+++--------+
-+-++----+++++-++--++-+++-+-++-+-+++--------
+-+-++----+-+++-++--++-+++-+-++-+-+++-------
++-+-++----+-+++-++--++-+++-+-++---+++------
-++-+-++---++-+++-++---+-+++-+-++---+++-----
--++-+-++---++-+++-++-+-+-+++-+-+----+++----
---++-+-++---++-+++-++++-+-+++-+------+++---
----++-+-+++--++-+++-+-++-+-+++-+------+++--
+----++-+-+++--++-+++-+-++-+-+++--------+++-
++----++-+--++--++-+++-+-++-+-+++--------+++
-++----++-++-++--++-+++-+-++-+-+++--------++
--+--++--+-+-++----++---++++++++-++-+-++-+-+
---+--++--+-+-++----++---+++++++++++-+-++-+-
+---+--++--+-+-++----++---+++++++-+++-+-++-+
-+---+--++-++-+-++----++---+++++++-+++-+-++-
--+---+--++-++-+-++---+++---+++++-+-+++-+-++
+--+---+--+--++-+-++--++++---+++++-+-+++-+-+
++--+---+-----++-+-++-+++++---+++++-+-+++-+-
-++--+---+-----++-+-++++++++---++-++-+-+++-+
--++--+---++----++-+-++++++++---++-++-+-+++-
+--++--+---++----++-+-++++++++----+-++-+-+++
-+--++--+---++----++-+-++++++++--+-+-++-+-++
--+-+--+-+-++--------++-++----++---+--++--+-
---+-+--+-++++---------+-++----++---+--++--+
+---+-+--+--+++-------+-+-++----++---+--++--
-+---+-+--+--+++------++-+-++-----+---+--++-
+-+---+-+-----+++------++-+-++-----+---+--++
-+-+---+-+-----+++------++-+-++--+--+---+--+
--+-+---+-+-----+++------++-+-++-++--+---+--
+--+-+---+-------+++------++-+-++-++--+---+-
-+--+-+---+-------+++-+----++-+-+--++--+---+
+-+--+-+-----------+++++----++-+-+--++--+---
-+-+--+-+--+--------++-++----++-+-+--++--+--
--++++++++---+-+--+-+-++-++--++-++-++----++-
---++++++++---+-+--+-++++-++--++--+-++----++
+---++++++++---+-+--+--+++-++--+++-+-++----+
++---++++++-+---+-+--++-+++-++--+++-+-++----
+++---++++++-+---+-+--++-+++-++---++-+-++---
++++---++++-+-+---+-+--++-+++-++---++-+-++--
+++++---+++--+-+---+-+--++-+++-++---++-+-++-
++++++---+++--+-+---+-+--++-+++-+----++-+-++
+++++++---+-+--+-+---+++--++-+++-+----++-+-+
++++++++---+-+--+-+----++--++-+++++----++-+-
-++++++++---+-+--+-+--+-++--++-++-++----++-+
"""


def string_to_array(string):
    # Convert strings of + and - to bool arrays
    string = string.strip().replace('+', '1').replace('-', '-1').split()
    return np.stack([np.fromstring(" ".join(string[i]), dtype=np.int32, sep=' ') for i in range(len(string))])



def array_code_gen(string):
    mat = string_to_array(string)
    N = mat.shape[0]
    assert mat.shape[0] == mat.shape[1]
    out = []
    for i in range(N):
        row_str = '['
        for j in range(N-1):
            row_str += f"{'+1, ' if mat[i, j] == 1 else '-1, '}"
        if mat[i, N-1] == 1:
            row_str += '+1'
        else:
            row_str += '-1'
        row_str += '],'
        out.append(row_str)
    return template.replace("{N}", str(N)).replace("{Matrix}", '\n    '.join(out))


if __name__ == "__main__":
    print(array_code_gen(had_44_will))